
// Mp3Decoder.cpp : implementation file
//

#include "stdafx.h"
#include "Mp3DecoderDlg.h"
#include "Mp3Decoder.h"
#include "afxdialogex.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#endif

VOID DumpDebugMessage( CHAR * fmt, ... )
{
	CHAR pszDebugDumpMessage[ MAX_PATH ] = "[DEBUG] ";
	
	va_list marker;

	va_start( marker, fmt);

	vsprintf( pszDebugDumpMessage + 8, fmt, marker );

	va_end( marker );

	strcat( pszDebugDumpMessage, "\n" );

	OutputDebugString( pszDebugDumpMessage );
}

DWORD WINAPI on_decode_audio_framebuffer( LPVOID params )
{
	CMp3DecoderDlg *  pMainDialog = (CMp3DecoderDlg *)(params);

	BOOL bDecode = FALSE;

	ULONG nBufferLen = 0;		

	ULONGLONG	 nSrcVideoSampleTime = 0;

	CString strLine;

	while ( TRUE && pMainDialog->m_bDecodeBuffer )
    {
		nBufferLen = 0;	

		if ( pMainDialog->m_pTxtFile != NULL )
		{
			if ( pMainDialog->m_pTxtFile->ReadString( strLine ) )
			{
				CStringVector strVector = pMainDialog->SplitString(strLine, ",", true);

				if ( strVector.size() >= 2 )
				{
					nBufferLen = atoi( strVector[ 0 ] );

					nSrcVideoSampleTime = _atoi64(  strVector[ 1 ] );
				}
			}
		}

		if (  pMainDialog->m_nCurDecodeSample >= ( pMainDialog->m_nTotalAudioSamples - 1 ) )
		{
			pMainDialog->m_nCurDecodeSample = 0;

			pMainDialog->PostMessage( WM_COMMAND, MAKEWPARAM( IDC_BTN_STOP, BN_CLICKED ), 0 );

			break;
		}

		if ( pMainDialog->m_pBinFile != NULL && nBufferLen > 0 )
		{
			pMainDialog->m_pBinFile->Read( pMainDialog->m_pMp3FrameBuffer, nBufferLen );

			pMainDialog->m_nMp3FrameBufferLen = nBufferLen;

			bDecode = AMESDK_CODEC_DECODE_EX( pMainDialog->m_hAudioSwDecoderDev, pMainDialog->m_pMp3FrameBuffer, pMainDialog->m_nMp3FrameBufferLen, FALSE,  pMainDialog->m_pPCMFrameBuffer, &pMainDialog->m_nPCMFrameBufferLen );
			
			if ( bDecode && pMainDialog->m_nPCMFrameBufferLen )
			{
				 pMainDialog->m_nCurDecodeSample++;				

				if ( pMainDialog->m_pWavFile != NULL )
				{					
					CcWavWriteAudioSampleBuffer( pMainDialog->m_pWavFile, pMainDialog->m_pPCMFrameBuffer, pMainDialog->m_nPCMFrameBufferLen );					 
				}
			}
		}

		Sleep( 1 );
	}	

	return 0;
}

BOOL on_process_video_decoder_buffer( double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData )
{

	return TRUE;
}

// CMp3DecoderDlg dialog


CMp3DecoderDlg::CMp3DecoderDlg(CWnd* pParent /*=NULL*/)
	: CDialogEx(CMp3DecoderDlg::IDD, pParent)
{
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);	
	
	m_hAudioSwDecoderDev = 0xFFFFFFFF;	

	m_hMp3DecodeThread = NULL;	

	m_hMp3DecodeThreadNumber = 0;

	m_bDecodeBuffer = FALSE;	

	m_pMp3FrameBuffer  = NULL;

	m_nMp3FrameBufferLen = 0;

	m_pPCMFrameBuffer  = NULL;

	m_nPCMFrameBufferLen = 0;

	m_nTotalAudioSamples = 0;

	m_nCurDecodeSample = 0;

	m_pTxtFile = NULL;

	m_pBinFile = NULL;

	m_pWavFile = NULL;
}

void CMp3DecoderDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialogEx::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CMp3DecoderDlg)
	DDX_Control(pDX, IDC_BTN_START, m_btnStart);
	DDX_Control(pDX, IDC_BTN_STOP, m_btnStop);
	DDX_Control(pDX, IDC_BTN_BROWSER, m_btnBrowser);
	DDX_Control(pDX, IDC_EDIT_SRC_FILE_PATH, m_editSrcFilePath);
	DDX_Control(pDX, IDC_EDIT_DEST_FILE_PATH, m_editDestFilePath);
	DDX_Control(pDX, IDC_PROGRESS_TIME, m_progTimeBar);
	//}}AFX_DATA_MAP		
}

BEGIN_MESSAGE_MAP(CMp3DecoderDlg, CDialogEx)
	//{{AFX_MSG_MAP(CMp3DecoderDlg)
	ON_WM_PAINT()
	ON_WM_TIMER()
	ON_WM_DESTROY()
	ON_WM_QUERYDRAGICON()
	//}}AFX_MSG_MAP
	ON_BN_CLICKED(IDC_BTN_START, &CMp3DecoderDlg::OnBnClickedBtnStart)
	ON_BN_CLICKED(IDC_BTN_STOP, &CMp3DecoderDlg::OnBnClickedBtnStop)
	ON_BN_CLICKED(IDC_BTN_BROWSER, &CMp3DecoderDlg::OnBnClickedBtnBrowser)
END_MESSAGE_MAP()


// CMp3DecoderDlg message handlers

BOOL CMp3DecoderDlg::OnInitDialog()
{
	CDialogEx::OnInitDialog();

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon

	// TODO: Add extra initialization here

	// INITIALIZE COM RESOURCE
	//
	HRESULT hr = CoInitialize( NULL );

	m_pMp3FrameBuffer = new BYTE[ 4096 ];

	ZeroMemory( m_pMp3FrameBuffer, 4096 );

	m_pPCMFrameBuffer = new BYTE[ 16384 ];

	ZeroMemory( m_pPCMFrameBuffer, 16384 );
	
	CenterWindow();

	CString strCaption;

	strCaption.Format( "Yuan's Demo Software - MP3 Decoder" );

	SetWindowText( strCaption );

	InitializeCriticalSection( &m_hAccessFileCriticalSection );

	HwInitialize();

	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CMp3DecoderDlg::OnDestroy() 
{
	OnBnClickedBtnStop();

	HwUnInitialize();

	DeleteCriticalSection( &m_hAccessFileCriticalSection );

	if ( m_pMp3FrameBuffer != NULL )
	{
		delete [] m_pMp3FrameBuffer;

		m_pMp3FrameBuffer = NULL;
	}

	if ( m_pPCMFrameBuffer != NULL )
	{
		delete [] m_pPCMFrameBuffer;

		m_pPCMFrameBuffer = NULL;
	}	

	// UNINITIALIZE COM RESOURCE
	//
	CoUninitialize();
}

BOOL CMp3DecoderDlg::HwInitialize()
{	
	m_hAudioSwDecoderDev = AMESDK_CREATE( "Common Analog Decoder (MP3)", 1, 6, NULL, NULL, NULL );	
		
	if( m_hAudioSwDecoderDev & 0x80000000 ) 
	{ 
		m_hAudioSwDecoderDev = 0xFFFFFFFF; 

		return FALSE; 	
	}

	// SETUP AUDIO PATH (MP3.ENCODER) PROPERTIES
	//
	AMESDK_SET_FORMAT( m_hAudioSwDecoderDev, 2, 16, 48000 );	

	AMESDK_RUN( m_hAudioSwDecoderDev );	

	return TRUE;
}

BOOL CMp3DecoderDlg::HwUnInitialize()
{
	m_bDecodeBuffer = FALSE;

	Sleep( 100 );
	
	if( m_hAudioSwDecoderDev != 0xFFFFFFFF ) 
	{
		AMESDK_DESTROY( m_hAudioSwDecoderDev );
		
		m_hAudioSwDecoderDev = 0xFFFFFFFF; 
	}		

	return TRUE;
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CMp3DecoderDlg::OnPaint()
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, reinterpret_cast<WPARAM>(dc.GetSafeHdc()), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialogEx::OnPaint();
	}
}

// The system calls this function to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CMp3DecoderDlg::OnQueryDragIcon()
{
	return static_cast<HCURSOR>(m_hIcon);
}

CString CMp3DecoderDlg::GetWorkingPath()
{
	TCHAR szCurPath[MAX_PATH] = {0};

	GetModuleFileName(NULL, szCurPath, MAX_PATH);

	CString strCurPath = szCurPath;

	strCurPath = strCurPath.Left(strCurPath.ReverseFind('\\') + 1);

	return strCurPath;
}

void CMp3DecoderDlg::OnBnClickedBtnStart()
{
	// TODO: Add your control notification handler code here

	m_btnStart.EnableWindow( FALSE );

	m_btnStop.EnableWindow( TRUE );

	if ( !m_strSrcFilePath.IsEmpty() )
	{
		if ( IsFileExists( m_strSrcFilePath ) )
		{
			m_pTxtFile = NULL;

			m_pBinFile = NULL;		

			m_pBinFile = new CStdioFile( m_strSrcFilePath,  CFile::modeRead | CFile::typeBinary );

			CString m_strTxtFilePath = m_strSrcFilePath;			

			m_strTxtFilePath.Replace( ".MP3", ".TXT" );

			m_pTxtFile = new CStdioFile( m_strTxtFilePath,  CFile::modeRead | CFile::typeText );	

			ULONGLONG nTxtSize = m_pTxtFile->GetLength();

			m_nTotalAudioSamples = nTxtSize / 15;

			m_progTimeBar.SetRange( 0, m_nTotalAudioSamples );

			m_nCurDecodeSample = 0;

			CcWavCreateFile( m_strDestFilePath, "W", &m_pWavFile );

			if ( m_pWavFile != NULL )
			{
				CcWavSetAudioFormat( m_pWavFile, 2, 16, 48000, CCWAV_PCM ); 
			}

			SetTimer( 0x00000000, 10, NULL );

			m_bDecodeBuffer = TRUE;

			m_hMp3DecodeThread = CreateThread( NULL, 0, (LPTHREAD_START_ROUTINE)( on_decode_audio_framebuffer ), (LPVOID)(this), 0, &m_hMp3DecodeThreadNumber );	
		}
	}	
}


void CMp3DecoderDlg::OnBnClickedBtnStop()
{
	// TODO: Add your control notification handler code here

	m_bDecodeBuffer = FALSE;

	Sleep( 100 );

	m_btnStart.EnableWindow( TRUE );

	m_btnStop.EnableWindow( FALSE );	

	if ( m_pTxtFile != NULL )
	{
		m_pTxtFile->Close();

		delete m_pTxtFile;

		m_pTxtFile = NULL;
	}

	if ( m_pBinFile != NULL )
	{
		m_pBinFile->Close();

		delete m_pBinFile;

		m_pBinFile = NULL;
	}

	if ( m_pWavFile != NULL )
	{
		CcWavReleaseFile( m_pWavFile );

		m_pWavFile = NULL;
	}

	KillTimer( 0x00000000 );
}

BOOL CMp3DecoderDlg::IsFileExists( const TCHAR* pFile )
{
	WIN32_FIND_DATA FindFileData;

	HANDLE hFind;

	hFind = FindFirstFile(pFile, &FindFileData);

	if (hFind == INVALID_HANDLE_VALUE) 
	{
		return FALSE;
	} 
	else 
	{
		FindClose(hFind);

		return TRUE;
	}
}

void CMp3DecoderDlg::OnBnClickedBtnBrowser()
{
	// TODO: Add your control notification handler code here

	// SELECT THE MP3 FILE
	//
	OPENFILENAME ofn;

	CHAR psz[ MAX_PATH ];

	ZeroMemory( &ofn, sizeof(ofn) );

	ofn.lStructSize = sizeof(ofn);

	ofn.hwndOwner = m_hWnd;

	ofn.lpstrFile = psz;

	ofn.lpstrFile[ 0 ] = '\0';

	ofn.nMaxFile = sizeof(psz);

	ofn.lpstrFilter = "MP3\0*.MP3\0";

	ofn.nFilterIndex = 1;

	ofn.lpstrFileTitle = NULL;

	ofn.nMaxFileTitle = 0;

	ofn.lpstrInitialDir = NULL;

	ofn.Flags = OFN_PATHMUSTEXIST | OFN_FILEMUSTEXIST;

	GetOpenFileName( &ofn );

	if( strlen( psz ) > 0 ) 
	{
		m_strSrcFilePath = psz;

		m_editSrcFilePath.SetWindowText( m_strSrcFilePath );

		m_strDestFilePath = m_strSrcFilePath;

		m_strDestFilePath.Replace( ".MP3", ".WAV" );

		m_editDestFilePath.SetWindowText( m_strDestFilePath );
	}
}

void CMp3DecoderDlg::OnTimer(UINT_PTR nIDEvent) 
{
	// TODO: Add your message handler code here and/or call default
	
	if( nIDEvent == 0x00000000 ) 
	{		
		m_progTimeBar.SetPos( m_nCurDecodeSample );
	}

	CDialogEx::OnTimer(nIDEvent);
}

CStringVector CMp3DecoderDlg::SplitString(const CString& strSource, const CString& delim, bool bRemoveNone)
{
	CStringVector strRows;

	int nStart = 0;

	int delimLen = delim.GetLength();

	int nPos = strSource.Find(delim, nStart);

	while(nPos >= 0)
	{	
		if(bRemoveNone) 
		{
			if(nPos > nStart)
			{
				strRows.push_back(strSource.Mid(nStart, nPos - nStart));	
			}
		}
		else 
		{
			strRows.push_back(strSource.Mid(nStart, nPos - nStart));		
		}

		nStart = nPos + delimLen;

		nPos = strSource.Find(delim, nStart);	
	}	
	
	int length = strSource.GetLength();

	if(bRemoveNone)
	{
		if(length > nStart)
		{
			strRows.push_back(strSource.Mid(nStart, length - nStart));
		}
	} 
	else
	{
		if(length >= nStart)
		{
			strRows.push_back(strSource.Mid(nStart, length - nStart));
		}
	}

	return strRows;
}